<?php



function woo_options(){
// VARIABLES
$themename = "Backstage";
$manualurl = 'http://www.woothemes.com/support/theme-documentation/backstage/';
$shortname = "woo";



$GLOBALS['template_path'] = get_bloginfo('template_directory');

//Access the WordPress Categories via an Array
$woo_categories = array();  
$woo_categories_obj = get_categories('hide_empty=0');
foreach ($woo_categories_obj as $woo_cat) {
    $woo_categories[$woo_cat->cat_ID] = $woo_cat->cat_name;}
$categories_tmp = array_unshift($woo_categories, "Select a category:");    
       
//Access the WordPress Pages via an Array
$woo_pages = array();
$woo_pages_obj = get_pages('sort_column=post_parent,menu_order');    
foreach ($woo_pages_obj as $woo_page) {
    $woo_pages[$woo_page->ID] = $woo_page->post_name; }
$woo_pages_tmp = array_unshift($woo_pages, "Select a page:");       


//Testing 
$options_select = array("one","two","three","four","five"); 
$options_radio = array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five"); 

//Stylesheets Reader
$alt_stylesheet_path = TEMPLATEPATH . '/styles/';
$alt_stylesheets = array();

if ( is_dir($alt_stylesheet_path) ) {
    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) { 
        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) {
            if(stristr($alt_stylesheet_file, ".css") !== false) {
                $alt_stylesheets[] = $alt_stylesheet_file;
            }
        }    
    }
}

//More Options
$all_uploads_path = get_bloginfo('home') . '/wp-content/uploads/';
$all_uploads = get_option('woo_uploads');
$other_entries = array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");



// THIS IS THE DIFFERENT FIELDS
$options = array();   

$options[] = array( "name" => "General Settings",
                    "type" => "heading");
                        
$options[] = array( "name" => "Theme Stylesheet",
					"desc" => "Select your themes alternative color scheme.",
					"id" => $shortname."_alt_stylesheet",
					"std" => "default.css",
					"type" => "select",
					"options" => $alt_stylesheets);

$options[] = array( "name" => "Custom Logo",
					"desc" => "Upload a logo for your theme, or specify the image address of your online logo. (http://yoursite.com/logo.png)",
					"id" => $shortname."_logo",
					"std" => "",
					"type" => "upload");    
                                                                                     
$options[] = array( "name" => "Custom Favicon",
					"desc" => "Upload a 16px x 16px Png/Gif image that will represent your website's favicon.",
					"id" => $shortname."_custom_favicon",
					"std" => "",
					"type" => "upload"); 
					
                                               
$options[] = array( "name" => "Tracking Code",
					"desc" => "Paste your Google Analytics (or other) tracking code here. This will be added into the footer template of your theme.",
					"id" => $shortname."_google_analytics",
					"std" => "",
					"type" => "textarea");        

$options[] = array( "name" => "RSS URL",
					"desc" => "Enter your preferred RSS URL. (Feedburner or other)",
					"id" => $shortname."_feedburner_url",
					"std" => "",
					"type" => "text");
    
					
$options[] = array( "name" => "Theme Setup",
                    "type" => "heading"); 
                    
$options[] = array( "name" => "Blog Category",
                    "desc" => "Select a category for blogging.",
                    "id" => $shortname."_blog_cat",
                    "std" => "Select a Category:",
                    "type" => "select",
                    "options" => $woo_categories); 
                    
$options[] = array( "name" => "Photo Category",
                    "desc" => "Select a category for photo entries.",
                    "id" => $shortname."_photo_cat",
                    "std" => "Select a Category:",
                    "type" => "select",
                    "options" => $woo_categories);
                    
$options[] = array( "name" => "Video Category",
                    "desc" => "Select a category for video entries.",
                    "id" => $shortname."_video_cat",
                    "std" => "Select a Category:",
                    "type" => "select",
                    "options" => $woo_categories); 
					
$options[] = array( "name" => "Music/Discography Category",
                    "desc" => "Select a category for audio entries.",
                    "id" => $shortname."_audio_cat",
                    "std" => "Select a Category:",
                    "type" => "select",
                    "options" => $woo_categories); 
                    
$options[] = array( "name" => "Shows Category",
                    "desc" => "Select a category for show entries.",
                    "id" => $shortname."_shows_cat",
                    "std" => "Select a Category:",
                    "type" => "select",
                    "options" => $woo_categories); 
                    
$options[] = array( "name" => "Media Tag",
                    "desc" => "Enter tag name for media entries.",
                    "id" => $shortname."_media_tag",
                    "std" => "",
                    "type" => "text");                    
					
$options[] = array( "name" => "Home Page",
					"type" => "heading"); 
					
$options[] = array( "name" => "Band Bio",
                    "desc" => "Write a description or bio of your band here. This will appear on your homepage next to the Bio Photo.",
                    "id" => $shortname."_bio_content",
                    "std" => "",
                    "type" => "textarea"); 					   
                                        
$options[] = array( "name" => "Band Bio Photo",
                    "desc" => "Upload or enter an image that will be on the homepage as the bio photo. Maximum width is 160px",
                    "id" => $shortname."_bio_image",
                    "std" => "",
                    "type" => "upload");   



					
$options[] = array( "name" => "Home Page Slider",
					"type" => "heading"); 
						
$options[] = array( "name" => "Activate Slider",
					"desc" => "Activate the slider on your homepage.",
					"id" => $shortname."_slider",
					"std" => "false",
					"type" => "checkbox");
                     		
$options[] = array( "name" => "Slider Height",
                    "desc" => "Adjust the height of your slider.",
                    "id" => $shortname."_slider_height",
                    "std" => "375",
                    "type" => "text");
					
$options[] = array( "name" => "Slider Auto",
                    "desc" => "Make the slider automate automatically after a set timeout in milliseconds. <strong>0 = off</strong>",
                    "id" => $shortname."_slider_auto",
                    "std" => "0",
                    "type" => "text");
					
$options[] = array( "name" => "Slider Speed",
                    "desc" => "Set the slide speed between frames in milliseconds.",
                    "id" => $shortname."_slider_speed",
                    "std" => "500",
                    "type" => "text");
					
				
					
$options[] = array( "name" => "Use Image Resizer",
                    "desc" => "Make use of this if you want the slider images to be resized dynamically. Might increase loading times.",
                    "id" => $shortname."_slider_dynamic",
                    "std" => "false",
                    "type" => "checkbox");
				
//Populate
$k = 0;
while ($k < 10){
$k++;
					
$options[] = array( "name" => "Slider Image #" . $k,
					"desc" => "Upload an image for your slider. Will be auto resized " . $k,
					"id" => $shortname."_slider_" . $k,
					"std" => "",
					"type" => "upload");
} 				

$options[] = array( "name" => "Navigation",
					"type" => "heading");    

$options[] = array( "name" => "Category Navigation",
					"desc" => "Swap the Page navigation for a Category navigation. ",
					"id" => $shortname."_cat_menu",
					"std" => "false",
					"type" => "checkbox");    

$options[] = array( "name" => "Exclude Pages or Categories from Navigation",
					"desc" => "Enter a comma-separated list of <a href='http://support.wordpress.com/pages/8/'>ID's</a> that you would like to exclude from the top navigation. (e.g. 12,23,27,44)",
					"id" => $shortname."_nav_exclude",
					"std" => "",
					"type" => "text");
					
$options[] = array( "name" => "Media Tag Nav Item",
					"desc" => "Add a nav item for the media tag.",
					"id" => $shortname."_nav_media_tag",
					"std" => "false",
					"type" => "checkbox");
					
					
					
					
$options[] = array( "name" => "Music Player",
					"type" => "heading");
									
$options[] = array( "name" => "Background Color",
                    "desc" => "<a href=\"JavaScript:_whichField='woo_player_back';CLCPshowPicker({_hex: document.getElementById('woo_player_back').value});\">Choose a Color</a>",
					"id" => $shortname."_player_back",
					"std" => "000000",
					"type" => "text"); 	
					
$options[] = array( "name" => "Front Color",
                    "desc" => "<a href=\"JavaScript:_whichField='woo_player_front';CLCPshowPicker({_hex: document.getElementById('woo_player_front').value});\">Choose a Color</a>",
					"id" => $shortname."_player_front",
					"std" => "FFFFFF",
					"type" => "text"); 					
					
$options[] = array( "name" => "Lighter Color",
                    "desc" => "<a href=\"JavaScript:_whichField='woo_player_light';CLCPshowPicker({_hex: document.getElementById('woo_player_light').value});\">Choose a Color</a>",
					"id" => $shortname."_player_light",
					"std" => "FFFF99",
					"type" => "text"); 	
					
$options[] = array( "name" => "Link track name",
					"desc" => "Enable this to link the track name to the source file.",
					"id" => $shortname."_player_link",
					"std" => "false",
					"type" => "checkbox"); 	
					
$options[] = array( "name" => "Display captions",
					"desc" => "Enable the captions to show on the player output.",
					"id" => $shortname."_player_captions",
					"std" => "true",
					"type" => "checkbox"); 
					
$options[] = array( "name" => "Music Archive Page",
					"type" => "heading");	
					
$options[] = array( "name" => "Featured Audio Heading",
                    "desc" => "Give a custom heading to your featured audio module.",
					"id" => $shortname."_featured_audio_heading",
					"std" => "Featured Tracks",
					"type" => "text"); 
					
$options[] = array( "name" => "Featured Audio Mid Page Writeup",
                    "desc" => "Add a bit of writeup to the mid section of the audio archive page.",
					"id" => $shortname."_featured_audio_writeup",
					"std" => "",
					"type" => "textarea"); 
					
$options[] = array( "name" => "Featured Audio Attachments",
                    "desc" => "Add the list of comma separated attachment ID's for the Audio attachments you want featured. (eg. 12,13,15,16) Find through MEDIA page.",
					"id" => $shortname."_featured_audio",
					"std" => "",
					"type" => "text"); 	
					
$options[] = array( "name" => "Downloadable Audio Files",
                    "desc" => "Add the list of comma separated attachment ID's for the Audio attachments you want downloadable. (eg. 12,13,15,16) Find through MEDIA page.",
					"id" => $shortname."_download_audio",
					"std" => "",
					"type" => "text"); 	

					
$options[] = array( "name" => "Misc",
					"type" => "heading");
					

$options[] = array( "name" => "Post Meta",
					"desc" => "Enable post meta's around the theme.",
					"id" => $shortname."_post_meta",
					"std" => "false",
					"type" => "checkbox"); 
					
						
		
								
 
$options[] = array( "name" => "Dynamic Images",
				    "type" => "heading");    

$options[] = array( "name" => "Enable Dynamic Image Resizer",
					"desc" => "This will enable the thumb.php script. It dynamically resizes images on your site.",
					"id" => $shortname."_resize",
					"std" => "true",
					"type" => "checkbox");    
                    
$options[] = array( "name" => "Automatic Image Thumbs",
					"desc" => "If no image is specified in the 'image' custom field then the first uploaded post image is used.",
					"id" => $shortname."_auto_img",
					"std" => "false",
					"type" => "checkbox");
					
$options[] = array( "name" => "Image Gallery Dimensions (Single)",
					"desc" => "Enter an integer value i.e. 250 for the desired size which will be used when dynamically creating the gallery images.",
					"id" => $shortname."_gallery_image_dimensions",
					"std" => "",
					"type" => array( 
									array(  'id' => $shortname. '_gallery_image_width',
											'type' => 'text',
											'std' => 130,
											'meta' => 'Width'),
									array(  'id' => $shortname. '_gallery_image_height',
											'type' => 'text',
											'std' => 130,
											'meta' => 'Height')
								  ));
								  
$options[] = array( "name" => "Image Gallery Dimensions (Archives)",
					"desc" => "Enter an integer value i.e. 250 for the desired size which will be used when dynamically creating the gallery images.",
					"id" => $shortname."_gallery_image_dimensions",
					"std" => "",
					"type" => array( 
									array(  'id' => $shortname. '_gallery_image_width_archive',
											'type' => 'text',
											'std' => 80,
											'meta' => 'Width'),
									array(  'id' => $shortname. '_gallery_image_height_archive',
											'type' => 'text',
											'std' => 80,
											'meta' => 'Height')
								  ));
								  
$options[] = array( "name" => "Lightbox (Single)",
					"desc" => "Enable lightbox for thumbnail images on posts.",
					"id" => $shortname."_gallery_image_lightbox_single",
					"std" => "false",
					"type" => "checkbox"); 
							  
$options[] = array( "name" => "Lightbox (Archives)",
					"desc" => "Enable lightbox for thumbnail images on the archive pages.",
					"id" => $shortname."_gallery_image_lightbox_archive",
					"std" => "false",
					"type" => "checkbox");   
								                                      
                                                                                                
//Advertising
$options[] = array( "name" => "Ads - Top Ad (468x60px)",
                    "type" => "heading");

$options[] = array( "name" => "Enable Ad",
					"desc" => "Enable the ad space",
					"id" => $shortname."_ad_top",
					"std" => "false",
					"type" => "checkbox");    

$options[] = array( "name" => "Adsense code",
					"desc" => "Enter your adsense code (or other ad network code) here.",
					"id" => $shortname."_ad_top_adsense",
					"std" => "",
					"type" => "textarea");

$options[] = array( "name" => "Image Location",
					"desc" => "Enter the URL to the banner ad image location.",
					"id" => $shortname."_ad_top_image",
					"std" => "http://www.woothemes.com/ads/woothemes-468x60-2.gif",
					"type" => "upload");

$options[] = array( "name" => "Destination URL",
					"desc" => "Enter the URL where this banner ad points to.",
					"id" => $shortname."_ad_top_url",
					"std" => "http://www.woothemes.com",
					"type" => "text");                        

$options[] = array( "name" => "Ads - Content Banner (468x60px)",
					"type" => "heading");

$options[] = array( "name" => "Enable Ad",
					"desc" => "Enable the ad space",
					"id" => $shortname."_ad_content",
					"std" => "false",
					"type" => "checkbox");    

$options[] = array( "name" => "Adsense code",
					"desc" => "Enter your adsense code (or other ad network code) here.",
					"id" => $shortname."_ad_content_adsense",
					"std" => "",
					"type" => "textarea");

$options[] = array( "name" => "Image Location",
					"desc" => "Enter the URL for this banner ad.",
					"id" => $shortname."_ad_content_image",
					"std" => "http://www.woothemes.com/ads/woothemes-468x60-2.gif",
					"type" => "upload");

$options[] = array( "name" => "Destination URL",
					"desc" => "Enter the URL where this banner ad points to.",
					"id" => $shortname."_ad_content_url",
					"std" => "http://www.woothemes.com",
					"type" => "text");                        
  
                    
                                            

update_option('woo_template',$options);      
update_option('woo_themename',$themename);   
update_option('woo_shortname',$shortname);
update_option('woo_manual',$manualurl);

                                     
// Woo Metabox Options
                    

$woo_metaboxes = array(

        "image" => array (
            "name" => "image",
            "label" => "Post Thumbnail (Blogs/News)",
            "type" => "upload",
            "desc" => "Upload file here..."
        ),
        
        "embed" => array (
            "name" => "embed",
            "label" => "Embed Code (Videos)",
            "type" => "textarea",
            "desc" => "Add embed code for video services like Youtube or Vimeo"
        ),
        "more_info" => array (
            "name"  => "more_info",
            "std"  => "",
            "label" => "More Info (Shows)",
            "type" => "text",
            "desc" => "Enter the url/web address of the venue map,venue website or google map."
        ),
		
		"release" => array (
            "name"  => "release",
            "std"  => "",
            "label" => "Release Date (Music)",
            "type" => "text",
            "desc" => "Add a release date for the album."
        )

		/*
        "track_information" => array (
            "name"  => "track_information",
            "std"  => "Enter track information here",
            "label" => "Track information",
            "type" => "textarea",
            "desc" => "If this a post containing a song/track add some track information for it to display correctly on the home page, e.g. 4.12secs | 320kbps | MP3"
        ),
        
       */
    );
    
update_option('woo_custom_template',$woo_metaboxes);      

/*
function woo_update_options(){
        $options = get_option('woo_template',$options);  
        foreach ($options as $option){
            update_option($option['id'],$option['std']);
        }   
}

function woo_add_options(){
        $options = get_option('woo_template',$options);  
        foreach ($options as $option){
            update_option($option['id'],$option['std']);
        }   
}


//add_action('switch_theme', 'woo_update_options'); 
if(get_option('template') == 'wooframework'){       
    woo_add_options();
} // end function 
*/


}

add_action('init','woo_options');  

?>